<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class FactStat extends Model
{
    protected $fillable = [
        'fact',
        'value',
        'is_active',
        'created_by',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}
