<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class GalleryAnalytics extends Model
{
    protected $fillable = [
        'event_id',
        'date',
        'views',
        'unique_visitors',
        'downloads',
        'face_searches',
        'selections',
    ];

    protected $casts = [
        'date' => 'date',
        'views' => 'integer',
        'unique_visitors' => 'integer',
        'downloads' => 'integer',
        'face_searches' => 'integer',
        'selections' => 'integer',
    ];

    public function event()
    {
        return $this->belongsTo(Event::class);
    }
}
