<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class MediaAnalytics extends Model
{
    protected $fillable = [
        'event_media_id',
        'views',
        'downloads',
    ];

    protected $casts = [
        'views' => 'integer',
        'downloads' => 'integer',
    ];

    public function media()
    {
        return $this->belongsTo(EventMedia::class, 'event_media_id');
    }
}
