<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Page extends Model
{
    const BUILTIN_TYPES = ['about', 'contact', 'privacy_policy', 'terms', 'cookie_policy'];

    protected $fillable = [
        'title',
        'slug',
        'type',
        'description',
        'content',
        'is_active',
        'created_by',
        'updated_by',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'content' => 'array',
    ];

    public function scopeCustomOnly($query)
    {
        return $query->where('type', 'other');
    }

    public function scopeBuiltIn($query)
    {
        return $query->whereIn('type', self::BUILTIN_TYPES);
    }

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function updater()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }
}
