<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Plan extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'slug',
        'price',
        'offer_price',
        'features',
        'images_limit',
        'events_limit',
        'storage_limit_gb',
        'has_watermark',
        'has_design_editor',
        'videos_limit',
        'max_file_size_mb',
        'has_guest_upload',
        'has_google_drive_import',
        'has_ftp_import',
        'has_custom_branding',
        'has_cloud_storage',
        'duration_type',
        'duration_months',
        'is_active',
        'created_by',
    ];

    protected $casts = [
        'price' => 'decimal:2',
        'offer_price' => 'decimal:2',
        'features' => 'array',
        'images_limit' => 'integer',
        'events_limit' => 'integer',
        'storage_limit_gb' => 'decimal:2',
        'has_watermark' => 'boolean',
        'has_design_editor' => 'boolean',
        'videos_limit' => 'integer',
        'max_file_size_mb' => 'integer',
        'has_guest_upload' => 'boolean',
        'has_google_drive_import' => 'boolean',
        'has_ftp_import' => 'boolean',
        'has_custom_branding' => 'boolean',
        'has_cloud_storage' => 'boolean',
        'duration_months' => 'integer',
        'is_active' => 'boolean',
    ];

    public function coupons()
    {
        return $this->belongsToMany(Coupon::class)->withTimestamps();
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}
