<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SupportTicket extends Model
{
    use HasFactory;

    protected $fillable = [
        'ticket_number',
        'subject',
        'message',
        'requester_name',
        'requester_email',
        'requester_phone',
        'priority',
        'status',
        'is_active',
        'resolved_at',
        'created_by',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'resolved_at' => 'datetime',
    ];

    public function assignments()
    {
        return $this->hasMany(SupportTicketAssignment::class);
    }

    public function currentAssignment()
    {
        return $this->hasOne(SupportTicketAssignment::class)
            ->where('is_active', true)
            ->latest('assigned_at');
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}
