<?php

namespace App\Policies;

use App\Models\User;
use App\Policies\Concerns\UsesPermissions;

abstract class BasePolicy
{
    use UsesPermissions;

    public function viewAny(User $user): bool
    {
        return $this->allows($user, 'view');
    }

    public function view(User $user, $model = null): bool
    {
        return $this->allows($user, 'view');
    }

    public function create(User $user): bool
    {
        return $this->allows($user, 'create');
    }

    public function update(User $user, $model = null): bool
    {
        return $this->allows($user, 'update');
    }

    public function delete(User $user, $model = null): bool
    {
        return $this->allows($user, 'delete');
    }

    public function export(User $user): bool
    {
        return $this->allows($user, 'export');
    }

    public function import(User $user): bool
    {
        return $this->allows($user, 'import');
    }

    public function manage(User $user): bool
    {
        return $this->allows($user, 'manage');
    }
}
