<?php

namespace App\Policies\Concerns;

use App\Models\User;

trait UsesPermissions
{
    protected string $module = '';

    protected function allows(User $user, string $action): bool
    {
        if ($this->module === '') {
            return false;
        }

        $permission = $this->module.'.'.$action;

        return $user->can($permission);
    }
}
