<?php

namespace App\Policies;

use App\Models\User;

class EventPolicy extends BasePolicy
{
    protected string $module = 'events';

    public function view(User $user, $model = null): bool
    {
        if (! parent::view($user, $model)) {
            return false;
        }

        if ($user->hasRole(['Super Admin', 'Admin'])) {
            return true;
        }

        return $model && (int) $model->created_by === (int) $user->id;
    }

    public function update(User $user, $model = null): bool
    {
        if (! parent::update($user, $model)) {
            return false;
        }

        if ($user->hasRole(['Super Admin', 'Admin'])) {
            return true;
        }

        return $model && (int) $model->created_by === (int) $user->id;
    }

    public function delete(User $user, $model = null): bool
    {
        if (! parent::delete($user, $model)) {
            return false;
        }

        if ($user->hasRole(['Super Admin', 'Admin'])) {
            return true;
        }

        return $model && (int) $model->created_by === (int) $user->id;
    }

    public function accessDesignEditor(User $user, $model = null): bool
    {
        if ($user->hasRole(['Super Admin', 'Admin'])) {
            return true;
        }

        // Must be the owner to access design editor
        if ($model && (int) $model->created_by !== (int) $user->id) {
            return false;
        }

        return (bool) ($user->plan?->has_design_editor ?? false);
    }
}
