<?php

namespace App\Policies;

use App\Models\NewsletterSubscriber;
use App\Models\User;

class NewsletterSubscriberPolicy
{
    public function viewAny(User $user): bool
    {
        return $user->can('newsletter-subscribers.view');
    }

    public function view(User $user, NewsletterSubscriber $subscriber): bool
    {
        return $user->can('newsletter-subscribers.view');
    }

    public function delete(User $user, NewsletterSubscriber $subscriber): bool
    {
        return $user->can('newsletter-subscribers.delete');
    }

    public function export(User $user): bool
    {
        return $user->can('newsletter-subscribers.export');
    }
}
