<?php

namespace App\Providers;

use App\Models\ActivityLog;
use App\Models\BlockedIp;
use App\Models\BlockedLocation;
use App\Models\BlogCategory;
use App\Models\BlogPost;
use App\Models\City;
use App\Models\Country;
use App\Models\Coupon;
use App\Models\Currency;
use App\Models\Event;
use App\Models\EventMedia;
use App\Models\ExtensionSetting;
use App\Models\FactStat;
use App\Models\Faq;
use App\Models\Language;
use App\Models\Page;
use App\Models\Plan;
use App\Models\Report;
use App\Models\SecurityAuditLog;
use App\Models\SecuritySetting;
use App\Models\SupportTicket;
use App\Models\SupportTicketAssignment;
use App\Models\SystemLog;
use App\Models\SystemSetting;
use App\Models\Testimonial;
use App\Models\User;
use App\Models\PaymentGateway;
use App\Models\UserDeleteRequest;
use App\Policies\ActivityLogPolicy;
use App\Policies\BlockedIpPolicy;
use App\Policies\BlockedLocationPolicy;
use App\Policies\BlogCategoryPolicy;
use App\Policies\BlogPostPolicy;
use App\Policies\CityPolicy;
use App\Policies\CountryPolicy;
use App\Policies\CouponPolicy;
use App\Policies\CurrencyPolicy;
use App\Policies\EventMediaPolicy;
use App\Policies\EventPolicy;
use App\Policies\ExtensionsPolicy;
use App\Policies\FactStatPolicy;
use App\Policies\FaqPolicy;
use App\Policies\LanguagePolicy;
use App\Policies\PagePolicy;
use App\Policies\PermissionPolicy;
use App\Policies\PaymentGatewayPolicy;
use App\Policies\PlanPolicy;
use App\Policies\ReportPolicy;
use App\Policies\RolePolicy;
use App\Policies\SecurityAuditLogPolicy;
use App\Policies\SecuritySettingsPolicy;
use App\Policies\StatePolicy;
use App\Policies\SupportTicketPolicy;
use App\Policies\SystemLogPolicy;
use App\Policies\SystemSettingPolicy;
use App\Policies\TestimonialPolicy;
use App\Policies\TicketAssignmentPolicy;
use App\Policies\UserPolicy;
use App\Policies\UserDeleteRequestPolicy;
use App\Models\State;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Gate;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class AuthServiceProvider extends ServiceProvider
{
    protected $policies = [
        User::class => UserPolicy::class,
        Role::class => RolePolicy::class,
        Permission::class => PermissionPolicy::class,
        Country::class => CountryPolicy::class,
        State::class => StatePolicy::class,
        City::class => CityPolicy::class,
        Currency::class => CurrencyPolicy::class,
        Language::class => LanguagePolicy::class,
        Event::class => EventPolicy::class,
        EventMedia::class => EventMediaPolicy::class,
        Plan::class => PlanPolicy::class,
        Coupon::class => CouponPolicy::class,
        PaymentGateway::class => PaymentGatewayPolicy::class,
        SupportTicket::class => SupportTicketPolicy::class,
        SupportTicketAssignment::class => TicketAssignmentPolicy::class,
        Faq::class => FaqPolicy::class,
        SystemSetting::class => SystemSettingPolicy::class,
        SecuritySetting::class => SecuritySettingsPolicy::class,
        ExtensionSetting::class => ExtensionsPolicy::class,
        Page::class => PagePolicy::class,
        SystemLog::class => SystemLogPolicy::class,
        ActivityLog::class => ActivityLogPolicy::class,
        BlockedIp::class => BlockedIpPolicy::class,
        BlockedLocation::class => BlockedLocationPolicy::class,
        SecurityAuditLog::class => SecurityAuditLogPolicy::class,
        Testimonial::class => TestimonialPolicy::class,
        FactStat::class => FactStatPolicy::class,
        BlogCategory::class => BlogCategoryPolicy::class,
        BlogPost::class => BlogPostPolicy::class,
        Report::class => ReportPolicy::class,
        UserDeleteRequest::class => UserDeleteRequestPolicy::class,
    ];

    public function boot(): void
    {
        $this->registerPolicies();

        Gate::before(function (User $user) {
            return $user->hasRole('Super Admin') ? true : null;
        });
    }
}
