<?php

namespace App\Services;

use App\Models\Event;
use App\Models\EventMedia;
use App\Models\GalleryAnalytics;
use App\Models\MediaAnalytics;
use Illuminate\Support\Facades\DB;

class AnalyticsService
{
    public function recordView(Event $event): void
    {
        try {
            GalleryAnalytics::updateOrCreate(
                ['event_id' => $event->id, 'date' => today()],
                ['views' => DB::raw('views + 1')]
            );
        } catch (\Throwable $e) {
            // Analytics should never break the page
        }
    }

    public function recordUniqueVisitor(Event $event): void
    {
        try {
            GalleryAnalytics::updateOrCreate(
                ['event_id' => $event->id, 'date' => today()],
                ['unique_visitors' => DB::raw('unique_visitors + 1')]
            );
        } catch (\Throwable $e) {
            //
        }
    }

    public function recordDownload(Event $event, ?EventMedia $media = null): void
    {
        try {
            GalleryAnalytics::updateOrCreate(
                ['event_id' => $event->id, 'date' => today()],
                ['downloads' => DB::raw('downloads + 1')]
            );

            if ($media) {
                MediaAnalytics::updateOrCreate(
                    ['event_media_id' => $media->id],
                    ['downloads' => DB::raw('downloads + 1')]
                );
            }
        } catch (\Throwable $e) {
            //
        }
    }

    public function recordFaceSearch(Event $event): void
    {
        try {
            GalleryAnalytics::updateOrCreate(
                ['event_id' => $event->id, 'date' => today()],
                ['face_searches' => DB::raw('face_searches + 1')]
            );
        } catch (\Throwable $e) {
            //
        }
    }

    public function recordSelection(Event $event): void
    {
        try {
            GalleryAnalytics::updateOrCreate(
                ['event_id' => $event->id, 'date' => today()],
                ['selections' => DB::raw('selections + 1')]
            );
        } catch (\Throwable $e) {
            //
        }
    }
}
