<?php

namespace App\Support;

use App\Models\ActivityLog;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Schema;

class ActivityLogger
{
    public static function logFromRequest(
        Request $request,
        string $action,
        ?string $subjectType = null,
        ?int $subjectId = null,
        ?string $description = null
    ): void {
        try {
            if (! Schema::hasTable('activity_logs')) {
                return;
            }
        } catch (\Exception $e) {
            return;
        }

        $user = $request->user();

        ActivityLog::create([
            'user_id' => $user?->id,
            'action' => $action,
            'subject_type' => $subjectType,
            'subject_id' => $subjectId,
            'description' => $description,
            'ip_address' => $request->ip(),
            'user_agent' => $request->userAgent(),
            'logged_at' => now(),
        ]);
    }
}
