<?php

namespace App\Support;

use App\Models\SystemSetting;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Schema;

class CloudStorageSettings
{
    private static ?array $cache = null;

    public static function get(): array
    {
        if (self::$cache !== null) {
            return self::$cache;
        }

        $defaults = [
            'enabled' => false,
            'provider' => 's3',
            'visibility' => 'private',
            'base_path' => '',
            'last_test_at' => null,
            'last_test_status' => 'disabled',
            'last_test_message' => '',
            'migration' => [
                'status' => 'idle',
                'processed' => 0,
                'failed' => 0,
                'total' => 0,
                'started_at' => null,
                'finished_at' => null,
                'last_error' => '',
                'last_id' => null,
            ],
            'limits' => [
                'enabled' => false,
                'configured' => false,
                'value' => null,
                'unit' => 'gb',
            ],
            'providers' => [
                's3' => [
                    'key' => '',
                    'secret' => '',
                    'region' => '',
                    'bucket' => '',
                    'endpoint' => '',
                    'url' => '',
                    'use_path_style_endpoint' => false,
                ],
                'gcs' => [
                    'project_id' => '',
                    'bucket' => '',
                    'key_file' => '',
                ],
                'gdrive' => [
                    'client_id' => '',
                    'client_secret' => '',
                    'refresh_token' => '',
                    'folder' => '',
                    'team_drive_id' => '',
                    'shared_folder_id' => '',
                ],
                'azure' => [
                    'account_name' => '',
                    'account_key' => '',
                    'container' => '',
                    'endpoint' => '',
                    'url' => '',
                ],
                'bunny' => [
                    'storage_zone' => '',
                    'access_key' => '',
                    'region' => '',
                    'endpoint' => '',
                    'url' => '',
                ],
                'wasabi' => [
                    'key' => '',
                    'secret' => '',
                    'region' => '',
                    'bucket' => '',
                    'endpoint' => '',
                    'url' => '',
                    'use_path_style_endpoint' => false,
                ],
            ],
        ];

        $payload = [];

        $hasTable = false;
        try { $hasTable = Schema::hasTable('system_settings'); } catch (\Exception $e) {}
        if ($hasTable) {
            $payload = SystemSetting::query()->value('payload');

            if (is_string($payload)) {
                $decoded = json_decode($payload, true);
                $payload = is_array($decoded) ? $decoded : [];
            }
        }

        $stored = is_array($payload) ? ($payload['cloud_storage'] ?? []) : [];

        self::$cache = array_replace_recursive($defaults, is_array($stored) ? $stored : []);

        return self::$cache;
    }

    public static function getValue(string $key, $default = null)
    {
        $settings = self::get();
        $value = data_get($settings, $key);

        return $value === null ? $default : $value;
    }

    public static function forgetCache(): void
    {
        self::$cache = null;
    }

    public static function encryptValue(?string $value): ?string
    {
        $value = trim((string) ($value ?? ''));
        if ($value === '') {
            return null;
        }

        return Crypt::encryptString($value);
    }

    public static function decryptValue(?string $value): ?string
    {
        $value = $value ?? '';
        if ($value === '') {
            return null;
        }

        try {
            return Crypt::decryptString($value);
        } catch (\Throwable $exception) {
            return null;
        }
    }
}
