<?php

namespace App\Support;

use App\Models\SystemSetting;
use Illuminate\Support\Facades\Schema;

class EventMediaSettings
{
    private static ?array $cache = null;

    public static function get(): array
    {
        if (self::$cache !== null) {
            return self::$cache;
        }

        $defaults = (array) config('events.media', []);
        $payload = [];

        $hasTable = false;
        try { $hasTable = Schema::hasTable('system_settings'); } catch (\Exception $e) {}
        if ($hasTable) {
            $payload = SystemSetting::query()->value('payload');

            if (is_string($payload)) {
                $decoded = json_decode($payload, true);
                $payload = is_array($decoded) ? $decoded : [];
            }
        }

        $stored = is_array($payload) ? ($payload['media'] ?? []) : [];

        $merged = array_replace_recursive($defaults, is_array($stored) ? $stored : []);
        if (isset($defaults['watermark'])) {
            $merged['watermark'] = array_merge(
                (array) $defaults['watermark'],
                (array) ($stored['watermark'] ?? [])
            );
        }

        self::$cache = $merged;

        return $merged;
    }

    public static function getValue(string $key, $default = null)
    {
        $settings = self::get();
        $value = data_get($settings, $key);

        return $value === null ? $default : $value;
    }

    public static function forgetCache(): void
    {
        self::$cache = null;
    }
}
