<?php

namespace App\Support;

use App\Models\SystemSetting;
use Illuminate\Support\Facades\Schema;

class LocaleSettings
{
    public static function general(): array
    {
        $defaults = [
            'default_language' => config('app.locale'),
            'enable_multi_language' => false,
        ];

        try {
            if (! Schema::hasTable('system_settings')) {
                return $defaults;
            }
        } catch (\Exception $e) {
            return $defaults;
        }

        $payload = SystemSetting::query()->value('payload');

        if (is_string($payload)) {
            $decoded = json_decode($payload, true);
            $payload = is_array($decoded) ? $decoded : [];
        }

        $general = is_array($payload) ? ($payload['general'] ?? []) : [];

        return array_merge($defaults, is_array($general) ? $general : []);
    }

    public static function isEnabled(): bool
    {
        $general = self::general();

        return (bool) ($general['enable_multi_language'] ?? false);
    }

    public static function defaultLocale(): string
    {
        $general = self::general();
        $default = trim((string) ($general['default_language'] ?? ''));

        return $default !== '' ? $default : config('app.locale');
    }
}
