<?php

namespace App\Support;

use App\Models\SecurityAuditLog;
use App\Models\User;
use Illuminate\Http\Request;

class SecurityAuditLogger
{
    public static function log(string $eventType, string $status, ?User $user, Request $request, array $metadata = []): void
    {
        SecurityAuditLog::create([
            'user_id' => $user?->id,
            'event_type' => $eventType,
            'status' => $status,
            'ip_address' => $request->ip(),
            'user_agent' => substr((string) $request->userAgent(), 0, 1000),
            'metadata' => $metadata ?: null,
            'logged_at' => now(),
        ]);
    }
}
