<?php

namespace App\Support;

use App\Models\SystemSetting;

class SecuritySettings
{
    public static function get(): array
    {
        $defaults = config('security.defaults', []);
        $payload = SystemSetting::query()->value('payload');
        if (is_string($payload)) {
            $decoded = json_decode($payload, true);
            $payload = is_array($decoded) ? $decoded : [];
        }
        $security = is_array($payload) ? ($payload['security'] ?? []) : [];

        return array_merge($defaults, $security);
    }

    public static function getValue(string $key, $default = null)
    {
        $settings = self::get();

        return $settings[$key] ?? $default;
    }
}
