<?php

namespace App\Support;

use App\Models\SystemSetting;

class SocialLoginSettings
{
    public static function providers(): array
    {
        $labels = config('system.social_providers', []);
        $payload = SystemSetting::query()->value('payload');

        if (is_string($payload)) {
            $decoded = json_decode($payload, true);
            $payload = is_array($decoded) ? $decoded : [];
        }

        $stored = is_array($payload) ? ($payload['social']['providers'] ?? []) : [];

        $providers = [];

        $drivers = self::driverMap();

        foreach ($labels as $key => $label) {
            $storedConfig = is_array($stored[$key] ?? null) ? $stored[$key] : [];
            $driverKey = $drivers[$key] ?? $key;
            $serviceConfig = config('services.' . $driverKey, []);

            $enabled = filter_var($storedConfig['enabled'] ?? false, FILTER_VALIDATE_BOOLEAN);

            $clientId = trim((string) ($storedConfig['client_id'] ?? $serviceConfig['client_id'] ?? ''));
            $clientSecret = trim((string) ($storedConfig['client_secret'] ?? $serviceConfig['client_secret'] ?? ''));
            $redirectUrl = trim((string) ($storedConfig['redirect_url'] ?? $serviceConfig['redirect'] ?? ''));

            if (! $enabled && $clientId !== '' && $clientSecret !== '') {
                $enabled = true;
            }

            $providers[$key] = [
                'key' => $key,
                'label' => $label,
                'enabled' => $enabled,
                'client_id' => $clientId,
                'client_secret' => $clientSecret,
                'redirect_url' => $redirectUrl,
            ];
        }

        return $providers;
    }

    public static function enabledProviders(): array
    {
        $providers = self::providers();
        $drivers = self::driverMap();
        $enabled = [];

        foreach ($providers as $key => $provider) {
            if (! isset($drivers[$key])) {
                continue;
            }

            if (! $provider['enabled']) {
                continue;
            }

            if ($provider['client_id'] === '' || $provider['client_secret'] === '') {
                continue;
            }

            $provider['driver'] = $drivers[$key];
            $enabled[$key] = $provider;
        }

        return array_values($enabled);
    }

    public static function providerConfig(string $key): ?array
    {
        $providers = self::providers();
        $drivers = self::driverMap();

        if (! isset($providers[$key], $drivers[$key])) {
            return null;
        }

        $provider = $providers[$key];
        $provider['driver'] = $drivers[$key];

        return $provider;
    }

    private static function driverMap(): array
    {
        return [
            'google' => 'google',
            'github' => 'github',
            'facebook' => 'facebook',
            'linkedin' => 'linkedin-openid',
            'x' => 'twitter-oauth-2',
        ];
    }
}
