<?php

namespace App\Support;

use App\Models\SystemLog;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Schema;
use Throwable;

class SystemLogger
{
    public static function log(
        string $level,
        string $source,
        string $message,
        array $context = [],
        ?int $userId = null
    ): void {
        try {
            if (! Schema::hasTable('system_logs')) {
                return;
            }
        } catch (\Exception $e) {
            return;
        }

        SystemLog::create([
            'level' => $level,
            'source' => $source,
            'message' => $message,
            'context' => $context,
            'logged_at' => now(),
            'created_by' => $userId,
        ]);
    }

    public static function fromException(Throwable $exception, Request $request): void
    {
        $status = method_exists($exception, 'getStatusCode') ? (int) $exception->getStatusCode() : null;
        if ($status !== null && $status < 500) {
            return;
        }

        $userId = $request->user()?->id;
        $routeName = $request->route()?->getName();
        $message = $exception->getMessage() !== '' ? $exception->getMessage() : 'Unhandled exception';

        self::log('error', 'admin', $message, [
            'exception' => get_class($exception),
            'file' => $exception->getFile(),
            'line' => $exception->getLine(),
            'route' => $routeName,
            'url' => $request->fullUrl(),
            'method' => $request->method(),
            'ip' => $request->ip(),
        ], $userId);
    }
}
