<?php

return [
    'types' => [
        'Wedding',
        'Anniversary',
        'Engagement',
        'Pre Wedding',
        'Maternity',
        'Birthday',
        'Baby Shot',
        'Picnic',
        'Conferences',
        'Meetups',
        'Get To Gather',
        'Kitty',
        'Welcome Party',
        'Sports',
        'Other',
    ],
    'media' => [
        'disk' => env('EVENT_MEDIA_DISK', 'client_media'),
        'original_disk' => env('EVENT_MEDIA_ORIGINAL_DISK', 'local'),
        'max_file_size' => env('EVENT_MEDIA_MAX_KB', 51200),
        'chunk_size' => env('EVENT_MEDIA_CHUNK_BYTES', 5242880),
        'max_width' => env('EVENT_MEDIA_MAX_WIDTH', 2000),
        'thumbnail_width' => env('EVENT_MEDIA_THUMB_WIDTH', 600),
        'quality' => env('EVENT_MEDIA_QUALITY', 82),
        'storage_limit_gb' => env('EVENT_STORAGE_LIMIT_GB', 6.1),
        'watermark' => [
            'enabled' => env('EVENT_MEDIA_WATERMARK', true),
            'image' => env('EVENT_MEDIA_WATERMARK_IMAGE'),
            'position' => env('EVENT_MEDIA_WATERMARK_POSITION', 'top_right'),
            'positions' => [
                'top_left' => 'Top Left',
                'top_center' => 'Top Center',
                'top_right' => 'Top Right',
                'center_left' => 'Center Left',
                'center' => 'Center',
                'center_right' => 'Center Right',
                'bottom_left' => 'Bottom Left',
                'bottom_center' => 'Bottom Center',
                'bottom_right' => 'Bottom Right',
            ],
        ],
        'ftp_path' => env('EVENT_FTP_PATH', storage_path('app/ftp')),

        // FIX #3: Memory protection limits
        'max_dimension' => env('EVENT_MEDIA_MAX_DIMENSION', 10000), // 10K pixels per side
        'max_pixels' => env('EVENT_MEDIA_MAX_PIXELS', 100000000), // 100 megapixels total

        // FIX #18: Duplicate detection
        'detect_duplicates' => env('EVENT_MEDIA_DETECT_DUPLICATES', true),
    ],
];
