<?php

return [
    /*
    |--------------------------------------------------------------------------
    | FFmpeg Configuration
    |--------------------------------------------------------------------------
    |
    | FIX #10: Configuration for FFmpeg video processing
    |
    */

    'enabled' => env('FFMPEG_ENABLED', false),

    'binary' => env('FFMPEG_BINARY', '/usr/bin/ffmpeg'),

    'probe_binary' => env('FFPROBE_BINARY', '/usr/bin/ffprobe'),

    /*
    |--------------------------------------------------------------------------
    | Thumbnail Settings
    |--------------------------------------------------------------------------
    |
    | Extract thumbnail at specified timestamp (in seconds)
    |
    */

    'thumbnail_at' => env('VIDEO_THUMBNAIL_AT_SECONDS', 5),

    /*
    |--------------------------------------------------------------------------
    | Video Limits
    |--------------------------------------------------------------------------
    |
    | Maximum duration for video processing (in seconds)
    |
    */

    'max_duration' => env('VIDEO_MAX_DURATION', 600), // 10 minutes
];
