<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('phone', 20)->nullable()->after('email');
            $table->string('gender', 20)->nullable()->after('phone');
            $table->string('profile_photo_path')->nullable()->after('gender');
            $table->string('address_line')->nullable()->after('profile_photo_path');
            $table->foreignId('country_id')->nullable()->after('address_line')->constrained()->nullOnDelete();
            $table->foreignId('state_id')->nullable()->after('country_id')->constrained()->nullOnDelete();
            $table->foreignId('city_id')->nullable()->after('state_id')->constrained()->nullOnDelete();
            $table->string('postal_code', 20)->nullable()->after('city_id');
            $table->boolean('is_active')->default(true)->after('postal_code');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropForeign(['country_id']);
            $table->dropForeign(['state_id']);
            $table->dropForeign(['city_id']);
            $table->dropColumn([
                'phone',
                'gender',
                'profile_photo_path',
                'address_line',
                'country_id',
                'state_id',
                'city_id',
                'postal_code',
                'is_active',
            ]);
        });
    }
};
