<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('events', function (Blueprint $table) {
            $table->id();
            $table->string('name', 150);
            $table->string('slug', 180)->unique();
            $table->string('type', 60);
            $table->text('details')->nullable();
            $table->date('event_date');
            $table->date('expiry_date')->nullable();
            $table->boolean('notifications_enabled')->default(true);
            $table->string('guest_pin')->nullable();
            $table->string('admin_pin')->nullable();
            $table->string('share_token', 64)->unique();
            $table->json('hashtags')->nullable();
            $table->boolean('is_active')->default(true);
            $table->foreignId('created_by')->nullable()->constrained('users')->nullOnDelete();
            $table->timestamps();

            $table->index(['type', 'event_date']);
            $table->index('expiry_date');
            $table->index('is_active');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('events');
    }
};
