<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('event_media', function (Blueprint $table) {
            $table->id();
            $table->foreignId('event_id')->constrained('events')->cascadeOnDelete();
            $table->string('disk', 50)->default('public');
            $table->string('original_path');
            $table->string('optimized_path')->nullable();
            $table->string('thumbnail_path')->nullable();
            $table->string('file_name');
            $table->string('file_type', 20);
            $table->string('mime_type', 100)->nullable();
            $table->unsignedBigInteger('size')->default(0);
            $table->unsignedInteger('width')->nullable();
            $table->unsignedInteger('height')->nullable();
            $table->unsignedInteger('duration')->nullable();
            $table->boolean('is_featured')->default(false);
            $table->boolean('is_cover')->default(false);
            $table->unsignedInteger('sort_order')->default(0);
            $table->string('status', 30)->default('pending');
            $table->json('meta')->nullable();
            $table->timestamps();

            $table->index(['event_id', 'file_type']);
            $table->index(['event_id', 'is_cover']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('event_media');
    }
};
