<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('support_tickets', function (Blueprint $table) {
            $table->id();
            $table->string('ticket_number', 30)->unique();
            $table->string('subject', 180);
            $table->text('message');
            $table->string('requester_name', 150);
            $table->string('requester_email', 150);
            $table->string('requester_phone', 25)->nullable();
            $table->string('priority', 20)->default('medium');
            $table->string('status', 20)->default('open');
            $table->boolean('is_active')->default(true);
            $table->timestamp('resolved_at')->nullable();
            $table->foreignId('created_by')->nullable()->constrained('users')->nullOnDelete();
            $table->timestamps();

            $table->index(['priority', 'status']);
            $table->index('is_active');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('support_tickets');
    }
};
