<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('blog_posts', function (Blueprint $table) {
            $table->id();
            $table->string('title', 200);
            $table->string('slug', 180)->unique();
            $table->string('author_name', 150)->nullable();
            $table->foreignId('category_id')->constrained('blog_categories')->cascadeOnDelete();
            $table->string('image')->nullable();
            $table->text('excerpt')->nullable();
            $table->longText('details')->nullable();
            $table->json('tags')->nullable();
            $table->boolean('is_bookmarked')->default(false);
            $table->boolean('is_active')->default(true);
            $table->timestamp('published_at')->nullable();
            $table->foreignId('created_by')->nullable()->constrained('users')->nullOnDelete();
            $table->timestamps();

            $table->index(['category_id', 'is_active', 'published_at']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('blog_posts');
    }
};
