<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('event_media_faces', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('event_id');
            $table->unsignedBigInteger('event_media_id');
            $table->binary('embedding');
            $table->float('confidence')->nullable();
            $table->json('bbox')->nullable();
            $table->timestamps();

            $table->index(['event_id', 'event_media_id']);
            $table->index('event_id');
            $table->foreign('event_media_id')->references('id')->on('event_media')->onDelete('cascade');
            $table->foreign('event_id')->references('id')->on('events')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('event_media_faces');
    }
};
