<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('event_media', function (Blueprint $table) {
            if (!Schema::hasColumn('event_media', 'is_guest_upload')) {
                $table->boolean('is_guest_upload')->default(false)->after('status');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('event_media', function (Blueprint $table) {
            if (Schema::hasColumn('event_media', 'is_guest_upload')) {
                $table->dropColumn('is_guest_upload');
            }
        });
    }
};
