<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('plans', function (Blueprint $table) {
            $table->boolean('has_watermark')->default(false)->after('storage_limit_gb');
            $table->boolean('has_design_editor')->default(false)->after('has_watermark');
        });
    }

    public function down(): void
    {
        Schema::table('plans', function (Blueprint $table) {
            $table->dropColumn(['has_watermark', 'has_design_editor']);
        });
    }
};
