<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (Schema::hasTable('drive_imports')) {
            return;
        }

        Schema::create('drive_imports', function (Blueprint $table) {
            $table->id();
            $table->foreignId('event_id')->constrained('events')->cascadeOnDelete();
            $table->string('folder_link', 2000);
            $table->string('folder_id', 255)->nullable();
            $table->string('resource_key', 255)->nullable();
            $table->string('status', 40)->default('discovering');
            $table->unsignedInteger('total_files')->default(0);
            $table->unsignedInteger('discovered_files')->default(0);
            $table->unsignedInteger('processed_files')->default(0);
            $table->unsignedInteger('failed_files')->default(0);
            $table->string('next_page_token', 255)->nullable();
            $table->text('last_error')->nullable();
            $table->timestamp('started_at')->nullable();
            $table->timestamp('finished_at')->nullable();
            $table->timestamps();

            $table->index(['status', 'event_id']);
            $table->index(['event_id', 'created_at']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('drive_imports');
    }
};
