<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (Schema::hasTable('drive_import_files')) {
            return;
        }

        Schema::create('drive_import_files', function (Blueprint $table) {
            $table->id();
            $table->foreignId('drive_import_id')->constrained('drive_imports')->cascadeOnDelete();
            $table->string('file_id', 150);
            $table->string('file_name', 500)->nullable();
            $table->string('mime_type', 120)->nullable();
            $table->unsignedBigInteger('size')->nullable();
            $table->string('status', 40)->default('pending');
            $table->text('error')->nullable();
            $table->timestamps();

            $table->index(['drive_import_id', 'status']);
            $table->index(['status']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('drive_import_files');
    }
};
