<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * FIX #14: Add per-event storage quota tracking
     */
    public function up(): void
    {
        Schema::table('events', function (Blueprint $table) {
            $table->unsignedBigInteger('storage_quota_bytes')->nullable()->after('is_active')
                ->comment('Per-event storage limit in bytes (null = no limit)');
            $table->unsignedBigInteger('storage_used_bytes')->default(0)->after('storage_quota_bytes')
                ->comment('Current storage usage in bytes');

            $table->index('storage_quota_bytes');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('events', function (Blueprint $table) {
            $table->dropColumn(['storage_quota_bytes', 'storage_used_bytes']);
        });
    }
};
