<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * FIX #16: Add soft deletes to event_media for recovery capability
     */
    public function up(): void
    {
        Schema::table('event_media', function (Blueprint $table) {
            $table->softDeletes();
            $table->index('deleted_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('event_media', function (Blueprint $table) {
            $table->dropSoftDeletes();
        });
    }
};
