<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * FIX #18: Add file hash for duplicate detection
     */
    public function up(): void
    {
        Schema::table('event_media', function (Blueprint $table) {
            $table->string('file_hash', 64)->nullable()->after('size')
                ->comment('SHA256 hash for duplicate detection');

            $table->index('file_hash');
            $table->index(['event_id', 'file_hash']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('event_media', function (Blueprint $table) {
            $table->dropColumn('file_hash');
        });
    }
};
