<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * FIX #20: Create audit log table for event media operations
     */
    public function up(): void
    {
        Schema::create('event_media_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('event_media_id')->constrained('event_media')->cascadeOnDelete();
            $table->foreignId('user_id')->nullable()->constrained('users')->nullOnDelete();
            $table->string('action', 50)->comment('upload, download, delete, restore, update');
            $table->string('ip_address', 45)->nullable();
            $table->text('user_agent')->nullable();
            $table->json('metadata')->nullable()->comment('Additional context data');
            $table->timestamps();

            $table->index('action');
            $table->index('created_at');
            $table->index(['event_media_id', 'action']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('event_media_logs');
    }
};
