<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // Change event_media.status to enum for data integrity
        if (Schema::hasColumn('event_media', 'status')) {
            Schema::table('event_media', function (Blueprint $table) {
                $table->enum('status', ['pending', 'processing', 'ready', 'failed'])
                      ->default('pending')
                      ->change();
            });
        }

        // Change orders.status to enum for data integrity
        if (Schema::hasColumn('orders', 'status')) {
            Schema::table('orders', function (Blueprint $table) {
                $table->enum('status', ['pending', 'completed', 'failed', 'refunded'])
                      ->default('pending')
                      ->change();
            });
        }

        // Change drive_imports.status to enum for data integrity
        if (Schema::hasColumn('drive_imports', 'status')) {
            Schema::table('drive_imports', function (Blueprint $table) {
                $table->enum('status', ['discovering', 'downloading', 'processing', 'completed', 'failed', 'cancelled'])
                      ->default('discovering')
                      ->change();
            });
        }

        // Change drive_import_files.status to enum for data integrity
        if (Schema::hasColumn('drive_import_files', 'status')) {
            Schema::table('drive_import_files', function (Blueprint $table) {
                $table->enum('status', ['pending', 'downloading', 'processing', 'completed', 'failed', 'skipped'])
                      ->default('pending')
                      ->change();
            });
        }
    }

    public function down(): void
    {
        // Revert event_media.status back to string
        if (Schema::hasColumn('event_media', 'status')) {
            Schema::table('event_media', function (Blueprint $table) {
                $table->string('status', 30)->default('pending')->change();
            });
        }

        // Revert orders.status back to string
        if (Schema::hasColumn('orders', 'status')) {
            Schema::table('orders', function (Blueprint $table) {
                $table->string('status')->default('pending')->change();
            });
        }

        // Revert drive_imports.status back to string
        if (Schema::hasColumn('drive_imports', 'status')) {
            Schema::table('drive_imports', function (Blueprint $table) {
                $table->string('status', 40)->default('discovering')->change();
            });
        }

        // Revert drive_import_files.status back to string
        if (Schema::hasColumn('drive_import_files', 'status')) {
            Schema::table('drive_import_files', function (Blueprint $table) {
                $table->string('status', 40)->default('pending')->change();
            });
        }
    }
};
