<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('event_media', function (Blueprint $table) {
            try {
                $table->index(['event_id', 'status'], 'event_media_event_id_status_index');
            } catch (\Throwable $e) {
                // Index may already exist
            }

            try {
                $table->index(['event_id', 'sort_order'], 'event_media_event_id_sort_order_index');
            } catch (\Throwable $e) {
                // Index may already exist
            }

            try {
                $table->index(['event_id', 'is_featured'], 'event_media_event_id_is_featured_index');
            } catch (\Throwable $e) {
                // Index may already exist
            }

            try {
                $table->index(['event_id', 'created_at'], 'event_media_event_id_created_at_index');
            } catch (\Throwable $e) {
                // Index may already exist
            }

            try {
                $table->index('status', 'event_media_status_index');
            } catch (\Throwable $e) {
                // Index may already exist
            }
        });

        // file_hash index separately since column may not exist
        if (Schema::hasColumn('event_media', 'file_hash')) {
            try {
                Schema::table('event_media', function (Blueprint $table) {
                    $table->index('file_hash', 'event_media_file_hash_index');
                });
            } catch (\Throwable $e) {
                // Index may already exist
            }
        }

        Schema::table('orders', function (Blueprint $table) {
            try {
                $table->index('status', 'orders_status_index');
            } catch (\Throwable $e) {
                // Index may already exist
            }

            try {
                $table->index('created_at', 'orders_created_at_index');
            } catch (\Throwable $e) {
                // Index may already exist
            }
        });
    }

    public function down(): void
    {
        Schema::table('event_media', function (Blueprint $table) {
            $indexes = [
                'event_media_event_id_status_index',
                'event_media_event_id_sort_order_index',
                'event_media_event_id_is_featured_index',
                'event_media_event_id_created_at_index',
                'event_media_status_index',
                'event_media_file_hash_index',
            ];

            foreach ($indexes as $index) {
                try {
                    $table->dropIndex($index);
                } catch (\Throwable $e) {
                    // Index may not exist
                }
            }
        });

        Schema::table('orders', function (Blueprint $table) {
            try {
                $table->dropIndex('orders_status_index');
            } catch (\Throwable $e) {
            }

            try {
                $table->dropIndex('orders_created_at_index');
            } catch (\Throwable $e) {
            }
        });
    }
};
