<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // Add usage tracking columns to coupons
        Schema::table('coupons', function (Blueprint $table) {
            $table->unsignedInteger('max_uses')->nullable()->after('is_active');
            $table->unsignedInteger('current_uses')->default(0)->after('max_uses');
        });

        // Add coupon_id to orders for tracking which coupon was applied
        Schema::table('orders', function (Blueprint $table) {
            $table->foreignId('coupon_id')
                  ->nullable()
                  ->after('plan_id')
                  ->constrained('coupons')
                  ->nullOnDelete();
        });
    }

    public function down(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->dropForeign(['coupon_id']);
            $table->dropColumn('coupon_id');
        });

        Schema::table('coupons', function (Blueprint $table) {
            $table->dropColumn(['max_uses', 'current_uses']);
        });
    }
};
