<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('plans', function (Blueprint $table) {
            $table->unsignedInteger('videos_limit')->nullable()->after('has_design_editor');
            $table->unsignedInteger('max_file_size_mb')->nullable()->after('videos_limit');
            $table->boolean('has_guest_upload')->default(true)->after('max_file_size_mb');
            $table->boolean('has_google_drive_import')->default(false)->after('has_guest_upload');
            $table->boolean('has_ftp_import')->default(false)->after('has_google_drive_import');
            $table->boolean('has_custom_branding')->default(false)->after('has_ftp_import');
            $table->boolean('has_cloud_storage')->default(false)->after('has_custom_branding');
        });
    }

    public function down(): void
    {
        Schema::table('plans', function (Blueprint $table) {
            $table->dropColumn([
                'videos_limit',
                'max_file_size_mb',
                'has_guest_upload',
                'has_google_drive_import',
                'has_ftp_import',
                'has_custom_branding',
                'has_cloud_storage',
            ]);
        });
    }
};
