<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Add columns only if they don't already exist (idempotent for partial failures)
        if (! Schema::hasColumn('orders', 'payment_gateway_id')) {
            Schema::table('orders', function (Blueprint $table) {
                $table->unsignedBigInteger('payment_gateway_id')
                    ->nullable()
                    ->after('payment_method');
            });
        }

        if (! Schema::hasColumn('orders', 'gateway_transaction_id')) {
            Schema::table('orders', function (Blueprint $table) {
                $table->string('gateway_transaction_id')
                    ->nullable()
                    ->after('payment_gateway_id');
            });
        }

        // Add index if it doesn't exist
        $indexExists = collect(DB::select("SHOW INDEX FROM orders WHERE Key_name = 'orders_payment_gateway_id_index'"))->isNotEmpty();

        if (! $indexExists) {
            Schema::table('orders', function (Blueprint $table) {
                $table->index('payment_gateway_id');
            });
        }

        // Add foreign key if it doesn't exist
        $fkExists = collect(DB::select("SHOW INDEX FROM orders WHERE Key_name = 'orders_payment_gateway_id_foreign'"))->isNotEmpty();

        if (! $fkExists) {
            Schema::table('orders', function (Blueprint $table) {
                $table->foreign('payment_gateway_id')
                    ->references('id')
                    ->on('payment_gateways')
                    ->nullOnDelete();
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->dropForeign(['payment_gateway_id']);
            $table->dropIndex(['payment_gateway_id']);
            $table->dropColumn(['payment_gateway_id', 'gateway_transaction_id']);
        });
    }
};
