<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('client_selections', function (Blueprint $table) {
            $table->id();
            $table->foreignId('event_id')->constrained()->cascadeOnDelete();
            $table->foreignId('event_media_id')->constrained()->cascadeOnDelete();
            $table->string('guest_name', 100)->nullable();
            $table->string('guest_email', 255)->nullable();
            $table->string('session_id', 100);
            $table->timestamps();

            $table->unique(['event_id', 'event_media_id', 'session_id'], 'uq_selection');
            $table->index('event_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('client_selections');
    }
};
