<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('gallery_analytics', function (Blueprint $table) {
            $table->id();
            $table->foreignId('event_id')->constrained()->cascadeOnDelete();
            $table->date('date');
            $table->unsignedInteger('views')->default(0);
            $table->unsignedInteger('unique_visitors')->default(0);
            $table->unsignedInteger('downloads')->default(0);
            $table->unsignedInteger('face_searches')->default(0);
            $table->unsignedInteger('selections')->default(0);
            $table->timestamps();

            $table->unique(['event_id', 'date']);
        });

        Schema::create('media_analytics', function (Blueprint $table) {
            $table->id();
            $table->foreignId('event_media_id')->constrained()->cascadeOnDelete();
            $table->unsignedInteger('views')->default(0);
            $table->unsignedInteger('downloads')->default(0);
            $table->timestamps();

            $table->unique('event_media_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('media_analytics');
        Schema::dropIfExists('gallery_analytics');
    }
};
