<?php

namespace Database\Seeders;

use App\Models\BlockedIp;
use App\Models\BlockedLocation;
use App\Models\Country;
use App\Models\User;
use Illuminate\Database\Seeder;

class BlockedSeeder extends Seeder
{
    public function run(): void
    {
        $creatorId = User::query()->where('email', 'test@example.com')->value('id');
        $countryId = Country::query()->orderBy('name')->value('id');

        BlockedIp::updateOrCreate(
            ['ip_address' => '203.0.113.10'],
            [
                'reason' => 'Demo blocked IP',
                'is_active' => true,
                'created_by' => $creatorId,
            ]
        );

        if ($countryId) {
            BlockedLocation::updateOrCreate(
                [
                    'country_id' => $countryId,
                    'state_id' => null,
                    'city_id' => null,
                ],
                [
                    'reason' => 'Demo blocked country',
                    'is_active' => true,
                    'created_by' => $creatorId,
                ]
            );
        }
    }
}
