<?php

namespace Database\Seeders;

use App\Models\Currency;
use Illuminate\Database\Seeder;

class CurrencySeeder extends Seeder
{
    public function run(): void
    {
        // Exchange rates relative to USD (approximate, admin can update).
        $currencies = [
            // Major global currencies
            ['code' => 'USD', 'name' => 'US Dollar',             'symbol' => '$',    'precision' => 2, 'exchange_rate' => 1.000000],
            ['code' => 'EUR', 'name' => 'Euro',                  'symbol' => "\u{20AC}",  'precision' => 2, 'exchange_rate' => 0.920000],
            ['code' => 'GBP', 'name' => 'British Pound',         'symbol' => "\u{00A3}",  'precision' => 2, 'exchange_rate' => 0.790000],
            ['code' => 'JPY', 'name' => 'Japanese Yen',          'symbol' => "\u{00A5}",  'precision' => 0, 'exchange_rate' => 149.500000],
            ['code' => 'CAD', 'name' => 'Canadian Dollar',       'symbol' => 'C$',  'precision' => 2, 'exchange_rate' => 1.360000],
            ['code' => 'AUD', 'name' => 'Australian Dollar',     'symbol' => 'A$',  'precision' => 2, 'exchange_rate' => 1.540000],
            ['code' => 'CHF', 'name' => 'Swiss Franc',           'symbol' => 'CHF', 'precision' => 2, 'exchange_rate' => 0.880000],

            // Asia
            ['code' => 'INR', 'name' => 'Indian Rupee',          'symbol' => "\u{20B9}",  'precision' => 2, 'exchange_rate' => 83.500000],
            ['code' => 'BDT', 'name' => 'Bangladeshi Taka',      'symbol' => "\u{09F3}",  'precision' => 2, 'exchange_rate' => 110.000000],
            ['code' => 'PKR', 'name' => 'Pakistani Rupee',       'symbol' => "\u{20A8}",  'precision' => 2, 'exchange_rate' => 278.000000],
            ['code' => 'IDR', 'name' => 'Indonesian Rupiah',     'symbol' => 'Rp',  'precision' => 0, 'exchange_rate' => 15700.000000],
            ['code' => 'MYR', 'name' => 'Malaysian Ringgit',     'symbol' => 'RM',  'precision' => 2, 'exchange_rate' => 4.470000],
            ['code' => 'PHP', 'name' => 'Philippine Peso',       'symbol' => "\u{20B1}",  'precision' => 2, 'exchange_rate' => 56.500000],
            ['code' => 'THB', 'name' => 'Thai Baht',             'symbol' => "\u{0E3F}",  'precision' => 2, 'exchange_rate' => 35.500000],
            ['code' => 'VND', 'name' => 'Vietnamese Dong',       'symbol' => "\u{20AB}",  'precision' => 0, 'exchange_rate' => 24500.000000],
            ['code' => 'SGD', 'name' => 'Singapore Dollar',      'symbol' => 'S$',  'precision' => 2, 'exchange_rate' => 1.340000],
            ['code' => 'HKD', 'name' => 'Hong Kong Dollar',      'symbol' => 'HK$', 'precision' => 2, 'exchange_rate' => 7.820000],
            ['code' => 'KRW', 'name' => 'South Korean Won',      'symbol' => "\u{20A9}",  'precision' => 0, 'exchange_rate' => 1330.000000],
            ['code' => 'TWD', 'name' => 'Taiwan Dollar',         'symbol' => 'NT$', 'precision' => 2, 'exchange_rate' => 31.500000],
            ['code' => 'CNY', 'name' => 'Chinese Yuan',          'symbol' => "\u{00A5}",  'precision' => 2, 'exchange_rate' => 7.250000],

            // Middle East
            ['code' => 'AED', 'name' => 'UAE Dirham',            'symbol' => "\u{062F}.\u{0625}",  'precision' => 2, 'exchange_rate' => 3.673000],
            ['code' => 'SAR', 'name' => 'Saudi Riyal',           'symbol' => "\u{FDFC}",  'precision' => 2, 'exchange_rate' => 3.750000],
            ['code' => 'KWD', 'name' => 'Kuwaiti Dinar',         'symbol' => "\u{062F}.\u{0643}",  'precision' => 3, 'exchange_rate' => 0.307000],
            ['code' => 'BHD', 'name' => 'Bahraini Dinar',        'symbol' => 'BD',  'precision' => 3, 'exchange_rate' => 0.376000],
            ['code' => 'QAR', 'name' => 'Qatari Riyal',          'symbol' => "\u{FDFC}",  'precision' => 2, 'exchange_rate' => 3.640000],
            ['code' => 'OMR', 'name' => 'Omani Rial',            'symbol' => "\u{FDFC}",  'precision' => 3, 'exchange_rate' => 0.385000],
            ['code' => 'JOD', 'name' => 'Jordanian Dinar',       'symbol' => 'JD',  'precision' => 3, 'exchange_rate' => 0.709000],
            ['code' => 'EGP', 'name' => 'Egyptian Pound',        'symbol' => "E\u{00A3}", 'precision' => 2, 'exchange_rate' => 50.500000],

            // Africa
            ['code' => 'NGN', 'name' => 'Nigerian Naira',        'symbol' => "\u{20A6}",  'precision' => 2, 'exchange_rate' => 1550.000000],
            ['code' => 'ZAR', 'name' => 'South African Rand',    'symbol' => 'R',   'precision' => 2, 'exchange_rate' => 18.200000],
            ['code' => 'KES', 'name' => 'Kenyan Shilling',       'symbol' => 'KSh', 'precision' => 2, 'exchange_rate' => 153.000000],
            ['code' => 'GHS', 'name' => 'Ghanaian Cedi',         'symbol' => "\u{20B5}",  'precision' => 2, 'exchange_rate' => 14.800000],
            ['code' => 'XOF', 'name' => 'West African CFA Franc','symbol' => 'CFA', 'precision' => 0, 'exchange_rate' => 603.000000],
            ['code' => 'XAF', 'name' => 'Central African CFA Franc', 'symbol' => 'FCFA', 'precision' => 0, 'exchange_rate' => 603.000000],
            ['code' => 'CDF', 'name' => 'Congolese Franc',       'symbol' => 'FC',  'precision' => 2, 'exchange_rate' => 2750.000000],
            ['code' => 'GNF', 'name' => 'Guinean Franc',         'symbol' => 'FG',  'precision' => 0, 'exchange_rate' => 8600.000000],
            ['code' => 'TZS', 'name' => 'Tanzanian Shilling',    'symbol' => 'TSh', 'precision' => 2, 'exchange_rate' => 2550.000000],
            ['code' => 'UGX', 'name' => 'Ugandan Shilling',      'symbol' => 'USh', 'precision' => 0, 'exchange_rate' => 3750.000000],
            ['code' => 'RWF', 'name' => 'Rwandan Franc',         'symbol' => 'RF',  'precision' => 0, 'exchange_rate' => 1300.000000],

            // Latin America
            ['code' => 'BRL', 'name' => 'Brazilian Real',        'symbol' => 'R$',  'precision' => 2, 'exchange_rate' => 4.950000],
            ['code' => 'MXN', 'name' => 'Mexican Peso',          'symbol' => 'MX$', 'precision' => 2, 'exchange_rate' => 17.200000],
            ['code' => 'ARS', 'name' => 'Argentine Peso',        'symbol' => 'AR$', 'precision' => 2, 'exchange_rate' => 870.000000],
            ['code' => 'CLP', 'name' => 'Chilean Peso',          'symbol' => 'CL$', 'precision' => 0, 'exchange_rate' => 950.000000],
            ['code' => 'COP', 'name' => 'Colombian Peso',        'symbol' => 'CO$', 'precision' => 2, 'exchange_rate' => 3950.000000],
            ['code' => 'PEN', 'name' => 'Peruvian Sol',          'symbol' => 'S/',  'precision' => 2, 'exchange_rate' => 3.720000],
            ['code' => 'UYU', 'name' => 'Uruguayan Peso',        'symbol' => '$U',  'precision' => 2, 'exchange_rate' => 39.500000],

            // Europe (non-EUR)
            ['code' => 'TRY', 'name' => 'Turkish Lira',          'symbol' => "\u{20BA}",  'precision' => 2, 'exchange_rate' => 30.500000],
            ['code' => 'PLN', 'name' => 'Polish Zloty',          'symbol' => "z\u{0142}", 'precision' => 2, 'exchange_rate' => 4.020000],
            ['code' => 'CZK', 'name' => 'Czech Koruna',          'symbol' => "K\u{010D}", 'precision' => 2, 'exchange_rate' => 23.200000],
            ['code' => 'SEK', 'name' => 'Swedish Krona',         'symbol' => 'kr',  'precision' => 2, 'exchange_rate' => 10.500000],
            ['code' => 'NOK', 'name' => 'Norwegian Krone',       'symbol' => 'kr',  'precision' => 2, 'exchange_rate' => 10.600000],
            ['code' => 'DKK', 'name' => 'Danish Krone',          'symbol' => 'kr',  'precision' => 2, 'exchange_rate' => 6.880000],
            ['code' => 'HUF', 'name' => 'Hungarian Forint',      'symbol' => 'Ft',  'precision' => 0, 'exchange_rate' => 360.000000],
            ['code' => 'RON', 'name' => 'Romanian Leu',          'symbol' => 'lei', 'precision' => 2, 'exchange_rate' => 4.580000],
            ['code' => 'UAH', 'name' => 'Ukrainian Hryvnia',     'symbol' => "\u{20B4}",  'precision' => 2, 'exchange_rate' => 41.500000],
            ['code' => 'RUB', 'name' => 'Russian Ruble',         'symbol' => "\u{20BD}",  'precision' => 2, 'exchange_rate' => 92.000000],

            // Others
            ['code' => 'NZD', 'name' => 'New Zealand Dollar',    'symbol' => 'NZ$', 'precision' => 2, 'exchange_rate' => 1.680000],
            ['code' => 'ILS', 'name' => 'Israeli Shekel',        'symbol' => "\u{20AA}",  'precision' => 2, 'exchange_rate' => 3.650000],

            // Crypto (approximate USD values)
            ['code' => 'BTC', 'name' => 'Bitcoin',               'symbol' => "\u{20BF}",  'precision' => 8, 'exchange_rate' => 0.000012],
            ['code' => 'ETH', 'name' => 'Ethereum',              'symbol' => "\u{039E}",  'precision' => 8, 'exchange_rate' => 0.000400],
            ['code' => 'USDC', 'name' => 'USD Coin',             'symbol' => 'USDC','precision' => 2, 'exchange_rate' => 1.000000],
        ];

        foreach ($currencies as $currency) {
            Currency::updateOrCreate(
                ['code' => $currency['code']],
                [
                    'name'          => $currency['name'],
                    'symbol'        => $currency['symbol'],
                    'precision'     => $currency['precision'],
                    'exchange_rate' => $currency['exchange_rate'],
                    'is_active'     => true,
                ]
            );
        }
    }
}
