<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class DatabaseSeeder extends Seeder
{
    use WithoutModelEvents;

    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        $this->call([
            LocationSeeder::class,
            LanguageSeeder::class,
            RoleSeeder::class,
            PermissionsSeeder::class,
            RolePermissionSeeder::class,
            PhotographerPermissionSeeder::class,
        ]);

        $user = User::firstOrCreate(
            ['email' => 'test@example.com'],
            [
                'name' => 'Test User',
                'email_verified_at' => now(),
                'password' => Hash::make('password'),
            ]
        );

        $user->syncRoles(['Super Admin']);

        $this->call([
            UserSeeder::class,
            SystemSettingsSeeder::class,
            ContentSeeder::class,
            PlanSeeder::class,
            CurrencySeeder::class,
            PaymentGatewaySeeder::class,
            SupportSeeder::class,
            EventSeeder::class,
            BlockedSeeder::class,
            LogsSeeder::class,
        ]);

        if (app()->environment('local') && Schema::hasTable('events')) {
            $this->call(DashboardSeeder::class);
        }
    }
}
