<?php

namespace Database\Seeders;

use App\Models\Event;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Str;

class EventSeeder extends Seeder
{
    public function run(): void
    {
        $creatorId = User::query()->where('email', 'test@example.com')->value('id');

        $events = [
            [
                'name' => 'Spring Wedding Showcase',
                'type' => 'Wedding',
                'details' => 'A curated gallery for the Spring Wedding showcase event.',
                'event_date' => now()->addDays(14)->toDateString(),
                'expiry_date' => now()->addMonths(6)->toDateString(),
                'guest_pin' => '1234',
                'admin_pin' => '9876',
                'hashtags' => ['spring', 'wedding', 'showcase'],
                'is_active' => true,
            ],
            [
                'name' => 'Studio Anniversary Night',
                'type' => 'Anniversary',
                'details' => 'Studio anniversary celebration gallery.',
                'event_date' => now()->addDays(30)->toDateString(),
                'expiry_date' => now()->addMonths(3)->toDateString(),
                'guest_pin' => null,
                'admin_pin' => null,
                'hashtags' => ['anniversary', 'studio'],
                'is_active' => true,
            ],
        ];

        foreach ($events as $eventData) {
            $slug = Str::slug($eventData['name']);
            $guestPin = $eventData['guest_pin'] ? Crypt::encryptString($eventData['guest_pin']) : null;
            $adminPin = $eventData['admin_pin'] ? Crypt::encryptString($eventData['admin_pin']) : null;

            $event = Event::firstOrCreate(
                ['slug' => $slug],
                [
                    'name' => $eventData['name'],
                    'type' => $eventData['type'],
                    'details' => $eventData['details'],
                    'event_date' => $eventData['event_date'],
                    'expiry_date' => $eventData['expiry_date'],
                    'notifications_enabled' => true,
                    'guest_pin' => $guestPin,
                    'admin_pin' => $adminPin,
                    'share_token' => Str::random(32),
                    'hashtags' => $eventData['hashtags'],
                    'is_active' => $eventData['is_active'],
                    'created_by' => $creatorId,
                ]
            );

            $event->fill([
                'name' => $eventData['name'],
                'type' => $eventData['type'],
                'details' => $eventData['details'],
                'event_date' => $eventData['event_date'],
                'expiry_date' => $eventData['expiry_date'],
                'notifications_enabled' => true,
                'guest_pin' => $guestPin,
                'admin_pin' => $adminPin,
                'hashtags' => $eventData['hashtags'],
                'is_active' => $eventData['is_active'],
                'created_by' => $creatorId,
            ])->save();
        }
    }
}
