<?php

namespace Database\Seeders;

use App\Models\Language;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Schema;

class LanguageSeeder extends Seeder
{
    public function run(): void
    {
        if (! Schema::hasTable('languages')) {
            return;
        }

        $languages = [
            ['name' => 'English', 'code' => 'en', 'native_name' => 'English', 'direction' => 'ltr'],
            ['name' => 'Hindi', 'code' => 'hi', 'native_name' => 'Hindi', 'direction' => 'ltr'],
            ['name' => 'Spanish', 'code' => 'es', 'native_name' => 'Espanol', 'direction' => 'ltr'],
            ['name' => 'French', 'code' => 'fr', 'native_name' => 'Francais', 'direction' => 'ltr'],
            ['name' => 'Arabic', 'code' => 'ar', 'native_name' => 'Arabic', 'direction' => 'rtl'],
            ['name' => 'Portuguese', 'code' => 'pt', 'native_name' => 'Portugues', 'direction' => 'ltr'],
            ['name' => 'German', 'code' => 'de', 'native_name' => 'Deutsch', 'direction' => 'ltr'],
        ];

        foreach ($languages as $language) {
            Language::updateOrCreate(
                ['code' => $language['code']],
                $language
            );
        }
    }
}
