<?php

namespace Database\Seeders;

use App\Models\City;
use App\Models\Country;
use App\Models\State;
use Illuminate\Database\Seeder;

class LocationSeeder extends Seeder
{
    public function run(): void
    {
        $india = Country::firstOrCreate(
            ['name' => 'India'],
            ['iso2' => 'IN', 'iso3' => 'IND', 'phone_code' => '91', 'is_active' => true]
        );

        $usa = Country::firstOrCreate(
            ['name' => 'United States'],
            ['iso2' => 'US', 'iso3' => 'USA', 'phone_code' => '1', 'is_active' => true]
        );

        $states = [
            $india->id => ['Delhi', 'Maharashtra', 'Karnataka'],
            $usa->id => ['California', 'New York'],
        ];

        foreach ($states as $countryId => $stateNames) {
            foreach ($stateNames as $stateName) {
                $state = State::firstOrCreate(
                    ['country_id' => $countryId, 'name' => $stateName],
                    ['is_active' => true]
                );

                $cityNames = match ($stateName) {
                    'Delhi' => ['New Delhi'],
                    'Maharashtra' => ['Mumbai', 'Pune'],
                    'Karnataka' => ['Bengaluru'],
                    'California' => ['Los Angeles', 'San Francisco'],
                    'New York' => ['New York City'],
                    default => [],
                };

                foreach ($cityNames as $cityName) {
                    City::firstOrCreate(
                        ['state_id' => $state->id, 'name' => $cityName],
                        ['is_active' => true]
                    );
                }
            }
        }
    }
}
