<?php

namespace Database\Seeders;

use App\Models\ActivityLog;
use App\Models\SecurityAuditLog;
use App\Models\SystemLog;
use App\Models\User;
use Illuminate\Database\Seeder;

class LogsSeeder extends Seeder
{
    public function run(): void
    {
        $userId = User::query()->where('email', 'test@example.com')->value('id');

        SystemLog::updateOrCreate(
            [
                'source' => 'system',
                'message' => 'Seeded system log entry.',
            ],
            [
                'level' => 'info',
                'context' => ['seed' => true],
                'logged_at' => now(),
                'created_by' => $userId,
            ]
        );

        ActivityLog::updateOrCreate(
            [
                'user_id' => $userId,
                'action' => 'login',
                'description' => 'Seeded login activity.',
            ],
            [
                'subject_type' => 'User',
                'subject_id' => $userId,
                'ip_address' => '127.0.0.1',
                'user_agent' => 'Seeder',
                'logged_at' => now(),
            ]
        );

        SecurityAuditLog::updateOrCreate(
            [
                'user_id' => $userId,
                'event_type' => 'login_success',
                'status' => 'success',
            ],
            [
                'ip_address' => '127.0.0.1',
                'user_agent' => 'Seeder',
                'metadata' => ['seed' => true],
                'logged_at' => now(),
            ]
        );
    }
}
